{*****************************************************************************
*
* Module:      DATALISTBOX.PAS
*
* Author:      Stefan Wloch
* Date:        12-08-1997
* Version:     1.0
*
* Environment: Delphi 1.0, 2.0 & 3.0
* Compiler:
* Target:      WINDOWS 95 & WINDOWS NT
*
*-----------------------------------------------------------------------------
* Description: TDataListBox Component
*-----------------------------------------------------------------------------
* Modifications:
*
* Date      By       Description
* --------------------------------------------------------------------
*
*
******************************************************************************}
unit datalistbox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, StdCtrls;

type
  TDataListBox = class(TListBox)
  protected
     function GetDataItem(ndx: Integer): LongInt;
     procedure SetDataItem(ndx: Integer; val: LongInt);
  public
     property DataItem[ndx: Integer]: LongInt read GetDataItem write SetDataItem;
  end;

procedure Register;

implementation

procedure Register;
begin
     RegisterComponents('Standard', [TDataListBox]);
end;

function TDataListBox.GetDataItem(ndx: Integer): Longint;
begin
     GetDataItem:=SendMessage(handle, LB_GETITEMDATA, ndx, 0);
end;

procedure TDataListBox.SetDataItem(ndx: Integer; val: Longint);
begin
     SendMessage(handle, LB_SETITEMDATA, ndx, val);
end;

end.
 